module.exports = async function(m) {
    /**
     * Instanciation des dépendences de la fonction
     */
    const axios = require('axios');
    const qs = require('qs');

    /**
     * Importation du fichier config contenant les données du BOT
     */
    const config = require('../config');

    /**
     * Fonction permettant d'envoyer des embed sur discord
     */
    const embed = require('../embed');

    /**
     * Si la commande n'est pas otp, alors finir la fonction
     */
    if (m.command !== "otp" && m.command !== "otptest") return false;

    /**
     * Si la commande ne contient pas 2 arguments, finir la fonction et renvoyer une erreur
     */
    if(m.args.length < 1) return embed(m.message, 'Need more arguments', 15158332, 'You need to give 1 arguments, example : **!otp 33612345678**', m.user);

    /**
     * Si le numéro de téléphone ou le service ne correspond pas aux regex, alors renvoyer une erreur
     */
    if(!m.args['0'].match(/^\d{8,14}$/g)) return embed(m.message, 'Bad phone number', 15158332, 'This phone number is not good, a good one : **33612345678**', m.user);
    /**
     * Si la commande est !otptest alors l'on passe en otp de test avec l'user test
     */
    m.user = m.command == "otptest" ? 'test' : m.user;

    /**
     * Si toutes les conditions ont été passées, alors envoyer une requête à l'api d'appel
     */
    try {
        let response = await axios.post(config.apiurl+'/call/getotp', qs.stringify({
            phone: m.args['0']
        }));

        if (response.data.status == 'success') {
            if(!response.data.otp) {
                return embed(m.message, 'OTP Not Found', 15158332, response.data.message, m.user);
            }
            return embed(m.message, 'OTP Found', 3066993, 'OTP is **' + response.data.otp + '**', m.user);
        } else {
            return embed(m.message, 'OTP Not Found', 15158332, response.data.message, m.user);
        }
    } catch (e) {
        console.error(error)
    }
}
